var worldLocation = 'ToBurninMemory_World.inq';
var world;

var tokens = {};

var lastlastWorldLocationID = 0;
var lastWorldLocationID = 0;
var currentWorldLocationID = 0;
var texthistory = [];
var combinationstore = {};
var finaldescriptionsegments = [];
var indialogue = false;

function redraw()
{
    $( 'body' ).removeClass( 'fade' );
    setTimeout(
        function () { $( 'body' ).addClass( 'fade' ); }
        , 1 );
    $( 'div' ).removeClass( 'fade' );
    setTimeout(
        function () { $( 'div' ).addClass( 'fade' ); }
        , 1 );

    setTimeout( function () { displayWorld(); }, 100 );
}

$(document).ready(function()
{
    inquisitorParse( worldLocation, finishedParsing );

    $( "digit" ).live( "click", function ()
    {
        var value = targetLocation = $( this ).text();
        var origin = targetLocation = $( this ).attr( "origin" );
        var index = targetLocation = $( this ).attr( "index" );
        console.log( "inquisitor: Digit Clicked. Current value: " + value + ". From: " + origin + ". Index: " + index );

        combinationstore[origin][index]++;

        if ( combinationstore[origin][index] > 9 )
        {
            combinationstore[origin][index] = 0;
        }

        $( "#objects" ).html( "" );
        processChildren();
    } );

	$( "vessel" ).live( "click", function ()
	{
	    targetLocation = $( this ).attr( "data" );

	    var token = $( this ).attr( "token" );
	    if ( token != '' )
	    {
	        tokens[token] = currentWorldLocationID;
	        console.log( "inquisitor: Added " + tokens[token] );
	    }

	    var action = $( this ).attr( "action" );
	    if ( action != '' )
	    {
	        if ( action === 'hide' )
	        {
	            world.rawlocations[currentWorldLocationID].hidden = true;
	            console.log( "inquisitor: Hidden Object: " + currentWorldLocationID );
	        }
	        console.log( "inquisitor: Performed Action: " + action );
	    }

	    lastlastWorldLocationID = lastWorldLocationID;
	    lastWorldLocationID = currentWorldLocationID;
	    currentWorldLocationID = targetLocation;

	    redraw();
	} );

	$( "#dialogue" ).live( "click", function ()
	{
	    redraw();
	} );

    //

	$( "activenote" ).live( "click", function ()
	{
	    var index = $( this ).attr( "index" );
	    world.rawlocations[currentWorldLocationID].descriptionsegments[index].active = true;

	    var givetoken = world.rawlocations[currentWorldLocationID].descriptionsegments[index].givetoken;
	    if ( givetoken !== '' )
	    {
	        tokens[givetoken] = currentWorldLocationID;
	        console.log( "inquisitor: Added " + givetoken );

	        redraw();
	    }
	    
	    var newtext = processBodyText( world.rawlocations[currentWorldLocationID].descriptionsegments );
	    $( "#note" ).html( newtext );
	} );
});

function loadUniverse(location)
{
	clear();

	$.ajax({ type: "POST", url: "http://api.xxiivv.com/paradise/beholder", data: { values:"{\"owner\":\""+universeId+"\",\"location\":\""+location+"\"}" }
	}).done(function( content_raw ) {
		var parsed = JSON.parse(content_raw);
		universeArray = parsed;
		saveWorld(universeArray);
	});
}

function finishedParsing( result )
{
    world = result;
    console.log( world );
    displayWorld();
}

function processBodyText( descriptionsegments, isevent, removefirst, length )
{
    var rawtext = '';
    var currentsegment = 0;

    if ( removefirst == undefined || removefirst == null )
    {
        removefirst = false;
    }

    if ( isevent )
    {
        var finaltextsegment = '';

        var starstatus = true;
        for ( var i = 0; i < descriptionsegments.length; i++ )
        {
            var segchar = descriptionsegments.charAt( i );
            
            if ( segchar === "*" )
            {
                if ( starstatus )
                {
                    finaltextsegment += "<emphasis>";
                }
                else
                {
                    finaltextsegment += "</emphasis>";
                }
                starstatus = !starstatus;
            }
            else
            {
                finaltextsegment += segchar;
            }
        }

        rawtext = finaltextsegment.substr( 0, length ) + "...";
    }
    else
    {
        for ( var index = 0; index < descriptionsegments.length; index++ )
        {
            if ( descriptionsegments[index].requiresactivation )
            {
                var requiredtoken = world.rawlocations[currentWorldLocationID].descriptionsegments[index].requiretoken;
                var requiredtokeninversion = world.rawlocations[currentWorldLocationID].descriptionsegments[index].requireinversion;
                var requiredtokenexists = ( tokens[requiredtoken] !== undefined && tokens[requiredtoken] !== null );

                if( requiredtokeninversion )
                {
                    requiredtokenexists = !requiredtokenexists;
                }

                if ( requiredtoken === '' || requiredtokenexists )
                {
                    if ( !world.rawlocations[currentWorldLocationID].descriptionsegments[index].active )
                    {
                        rawtext += "<activenote index='" + index + "'>" + descriptionsegments[index].text + "</activenote>";
                    }
                    else
                    {
                        if ( world.rawlocations[currentWorldLocationID].descriptionsegments[index].additional )
                        {
                            rawtext += descriptionsegments[index].text;
                        }

                        rawtext += "<activenoteinactive>" + descriptionsegments[index].postactivationtext + "</activenoteinactive>";
                    }
                }
            }
            else
            {
                var finaltextsegment = '';

                for ( var i = 0; i < descriptionsegments[index].text.length; i++ )
                {
                    var segchar = descriptionsegments[index].text.charAt( i );

                    if ( segchar === "*" )
                    {
                        if ( starstatus )
                        {
                            finaltextsegment += "<emphasis>";
                        }
                        else
                        {
                            finaltextsegment += "</emphasis>";
                        }
                        starstatus = !starstatus;
                    }
                    else
                    {
                        finaltextsegment += segchar;
                    }
                }

                rawtext += finaltextsegment;
            }
        }
    }

    var trimmedtext = rawtext.trim();

    if ( trimmedtext.charAt( 1 ) === ' ' )
    {
        var storedtext = trimmedtext;

        if ( removefirst )
        {
            console.log( "Found space after drop cap, removing..." );
            trimmedtext = trimmedtext.charAt( 0 ) + storedtext.substr( 2 );
        }
    }

    var description = ""; var quotefirst = ( trimmedtext.charAt( 0 ) === '"' );

    //

    var splitdescriptionQuote = trimmedtext.split( '"' );
    if ( splitdescriptionQuote.length > 0 )
    {
        var first = false;

        for ( var index = 0; index < splitdescriptionQuote.length; index++ )
        {
            if ( first )
            {
                description += '<quote>\u2018';
            }
            else
            {
                if ( description !== "" )
                {
                    description += '\u2019</quote>';
                }
            }
            first = !first;

            description += splitdescriptionQuote[index];
        }
    }

    if ( !removefirst )
    {
        var splitdescription = description.split( ' ' );
        description = quotefirst ? "<quote><first>" : "<first>";
        for ( var index = 0; index < splitdescription.length; ++index )
        {
            description += splitdescription[index];
            if ( index < splitdescription.length - 1 )
            {
                description += " ";
            }

            if ( index == 3 )
            {
                description += "</first><afterfirst = class='fade'>";
            }
        }
        description += "</afterfirst>";
    }

    //console.log( description );

    return description;
}

function findlocation( fullname )
{
    console.log( "inquisitor: Looking for location: " + fullname );
    for ( var id in world.rawlocations )
    {
        var location = world.rawlocations[id];

        //console.log( "inquisitor: Comparing fullname: " + fullname + ". To: " + location.fullname );
        if ( fullname.trim() == location.fullname.trim() )
        {
            console.log( "inquisitor: Found location: " + fullname );
            return location.id;
        }
    }

    return -1;
}

function processChildren()
{
    var locationmain = world.rawlocations[currentWorldLocationID].parent[world.rawlocations[currentWorldLocationID].name];
    if ( Object.keys( locationmain ).length > 3 )
    {
        if ( addedlinks > 0 )
        {
            //$( "#vessels" ).append( '\n' );
        }
        addedlinks = 0;

        child = 0;
        for ( var objectname in locationmain )
        {
            if ( child > 2 )
            {
                var childid = locationmain[objectname].id;

                if ( childid !== undefined && childid !== null )
                {
                    if ( childid != -1 )
                    {
                        console.log( "inquisitor: Enumerating Child: " + childid );
                        addvessel( childid, world.rawlocations[childid].name, true, null, null, null, '#objects' );
                    }
                }
            }
            child++;
        }
    }
}

var addedlinks = 0;
function addvessel( id, title, force, token, action, link, customid )
{
    if ( token === undefined || token === null )
    {
        token = '';
    }

    if ( action === undefined || action === null )
    {
        action = '';
    }

    if ( customid === undefined || customid === null )
    {
        customid = "#vessels"
    }

    if ( link === undefined || link === null )
    {
        link = world.rawlocations[currentWorldLocationID].linkoverrides[title];

        if ( link !== undefined && link !== null )
        {
            console.log( "inquisitor: Testing override link from: " + link.target );
        }
    }

    if ( link !== undefined && link !== null )
    {
        if ( link.displayaschild )
        {
            customid = '#objects';
        }
    }

    var mutual = false;
    var mutuallinks = world.rawlocations[id].linkoverrides;
    var mutuallink = mutuallinks[world.rawlocations[currentWorldLocationID].name];

    if( mutuallink !== undefined && mutuallink !== null )
    {
        console.log( "inquisitor: Found mutual override link from: " + mutuallink.target );
        mutual = true;
    }

    var finaltitle = title;
    if ( link !== undefined && link !== null )
    {
        if( link.hasconditional )
        {
            var hastoken = !( tokens[link.conditional] === undefined || tokens[link.conditional] === null );
            if ( !hastoken && !link.exclusionconditional )
            {
                if ( link.combinationcondition )
                {
                    console.log( "inquisitor: Combination condition found, displaying." );

                    if ( combinationstore[id] == undefined && combinationstore[id] == null )
                    {
                        combinationstore[id] = new Array();
                        combinationstore[id].push( 9 );
                        combinationstore[id].push( 9 );
                        combinationstore[id].push( 9 );
                        combinationstore[id].push( 9 );
                    }

                    var finalhtml = '<combination>&middot;';
                    var iscorrect = true;

                    for ( var digitindex = 0; digitindex < 4; digitindex++ )
                    {
                        finalhtml += "<digit origin='" + id + "' index='" + digitindex + "'>" + combinationstore[id][digitindex] + "</digit>";
                        if( digitindex < 3 )
                        {
                            finalhtml += "&middot;";
                        }

                        if( combinationstore[id][digitindex] != link.conditional.charAt(digitindex) )
                        {
                            iscorrect = false;
                        }
                    }

                    finalhtml += "&middot;</combination><br />"
                    $( customid ).append( finalhtml );

                    if( !iscorrect )
                    {
                        return false;
                    }
                    else
                    {
                        $( customid ).append( "\n" );
                    }
                }
                else
                {
                    console.log( "inquisitor: Condition: " + link.conditional + ". Not met" );
                    return false;
                }
            }
            if ( hastoken && link.exclusionconditional )
            {
                console.log( "inquisitor: Exclusion Condition: " + link.conditional + ". Met" );
                return false;
            }
        }

        finaltitle = link.title;
        console.log( "inquisitor: Renaming vessel attempting to link to: " + title + ". From: " + finaltitle );
    }
    else if ( !force && !mutual )
    {
        console.log( "inquisitor: Link not requested" );
        return false;
    }

    if ( world.rawlocations[id].hidden )
    {
        console.log( "inquisitor: " + id + " is hidden." );
        return false;
    }

    if ( customid === "#objects" )
    {
        var childdescriptioninparent = world.rawlocations[id].descriptioninparent;
        if ( childdescriptioninparent != "" )
        {
            var childdescriptioninparentsegment = { text: childdescriptioninparent.trimRight(), requiresactivation: false, active: false, postactivationtext: '', givetoken: '', requiretoken: '', requireinversion: false }

            console.log( "inquisitor: Adding Child's Parent Description: " + childdescriptioninparent );
            finaldescriptionsegments.push( childdescriptioninparentsegment );
        }
    }

    $( customid ).append( "<vessel data='" + id + "' token='" + token + "' action='" + action + "'>" + finaltitle + "</vessel><br />" );
    addedlinks++;
}

function displayWorld()
{
    clear();

    //

    var historytextfinal = "<history>"; var addedcount = 0;
    if ( texthistory.length > 0 )
    {
        while ( addedcount < texthistory.length )
        {
            /*if ( addedcount == 0 )
            {
                historytextfinal += "<faded>" + texthistory[addedcount] + "</faded>";
            }
            else
            {*/
                historytextfinal += texthistory[addedcount];
            //}
            addedcount++;
        }
    }
    $( "#history" ).html( historytextfinal + "</history>" );

    //

    var location = world.rawlocations[currentWorldLocationID];
    var locationname = location.name;

    if ( location.displayparent )
    {
        $( "#superlocation" ).html( location.namesegments[location.namesegments.length - 2] );
        //locationname = location.namesegments[location.namesegments.length - 2] + " - " + locationname;
    }

    $( "#location" ).html( locationname );
    $( "#region" ).html( "- " + location.region + " -" );
    $( "#subregion" ).html( "- " + location.subregion + " -" );
    $( "#eventprompt" ).hide();

	if ( location.eventid != -1 )
	{
	    var eventid = location.eventid;
	    var rawevent = world.rawevents[eventid];
	    if ( rawevent.text !== '' )
	    {
	        console.log( "inquisitor: Event condition: " + rawevent.condition );
	        var hastoken = !( tokens[rawevent.condition] === undefined || tokens[rawevent.condition] === null );
	        if ( hastoken || rawevent.condition == '' )
	        {
	            var rawnewtext = processBodyText( rawevent.text, true, false, 750 );
	            var newtext = "<div class='event'>" + rawnewtext + "<p id='eventfader' class='eventfader' /><img src='img/tbim_skull_512.jpg' id='eventprompt' /><div id='prompttext'>Activate Memory?<div/></div>";
	            $( "#event" ).html( newtext );
	            $( "#eventprompt" ).show();

	            if( rawevent.givetoken != '' )
	            {
	                tokens[rawevent.givetoken] = currentWorldLocationID;
	            }

	            //

	            if ( rawevent.soundurl != '' )
	            {
	                /*var sound = new Howl( {
	                    urls: [rawevent.soundurl.trim()]
	                } ).play();*/
	                console.log( "inquisitorParse: Playing sound: " + rawevent.soundurl );
	            }

                //
	        }
	    }
	}

	if ( location.dialogueid != -1 )
	{
	    var dialogueid = location.dialogueid;
	    var rawdialogue = world.rawdialogue[dialogueid];

	    if ( rawdialogue.text.length > 0 )
	    {
	        if ( rawdialogue.readprogress > rawdialogue.text.length -1 )
	        {
	            $( "#dialogue" ).hide();
	            $( "#dialoguefader1" ).hide();
	            $( "#dialoguefader2" ).hide();
	            $( "#dialoguedivider1" ).hide();
	            $( "#dialoguedivider2" ).hide();
	            console.log( "inquisitor: Dialogue Over" );
	            indialogue = false;
	        }
	        else
	        {
	            $( "#dialogue" ).show();
	            $( "#dialoguefader1" ).show();
	            $( "#dialoguefader2" ).show();
	            //$( "#dialoguedivider1" ).show();
	            $( "#dialoguedivider2" ).show();
	            indialogue = true;

	            var newtext = "<div class='dialogue'>" + processBodyText( rawdialogue.text[rawdialogue.readprogress], true, false ) + "\n\n</div>";
	            $( "#dialogue" ).html( newtext );
	            world.rawdialogue[dialogueid].readprogress++;
	        }
	    }
	}

	//$( "#lastnote" ).html( world.rawlocations[lastWorldLocationID].desc );
	//$( "#lastlastnote" ).html( world.rawlocations[lastlastWorldLocationID].desc );

	var child = 0;
	var firstchild = -1;
	var isfirstchild = false;
	for ( var objectname in world.rawlocations[currentWorldLocationID].parent )
	{
	    if ( child > 2 )
	    {
	        var parentid = world.rawlocations[currentWorldLocationID].parent.id;
	        var parentparentid = world.rawlocations[parentid].parent.id;
	        var childid = world.rawlocations[currentWorldLocationID].parent[objectname].id;

	        if ( childid !== undefined && childid !== null )
	        {
	            if ( firstchild === -1 )
	            {
	                firstchild = childid;
	                isfirstchild = ( firstchild == currentWorldLocationID );
	            }

	            if ( childid != -1 && childid != currentWorldLocationID )
	            {
	                var siblingname = world.rawlocations[childid].name;
	                var siblingsubregion = world.rawlocations[childid].subregion;
	                var oursubregion = world.rawlocations[currentWorldLocationID].subregion;
	                var insidesiblingsubregion = oursubregion === siblingsubregion;

	                if ( !world.rawlocations[childid].isobject && !location.isobject )
	                {
	                    var siblingname = insidesiblingsubregion ? siblingname : siblingsubregion;
	                    console.log( "inquisitor: Enumerating Sibling: " + childid + ". Giving Name: " + siblingname );
	                    addvessel( childid, siblingname, false );
	                }
	            }
	        }
	    }
	    child++;
	}

    //

	finaldescriptionsegments = location.descriptionsegments.slice();
	processChildren();

    //

	if ( location.descriptionsegments.length > 0 )
	{
	    var newtext = processBodyText( finaldescriptionsegments, false, false );
	    var rawtext = processBodyText( finaldescriptionsegments, false, true );
	    $( "#note" ).html( newtext );

	    if ( !indialogue && currentWorldLocationID != 0 )
	    {
	        texthistory.push( "\n\n" + rawtext );
	    }

	    if( $("#div4").height() > 300 )
	    {
	        console.log( "inquisitor: Removing first history" );
	        texthistory = texthistory.splice( 0, 1 );
	    }
	}

    //

	if ( addedlinks > 0 )
	{
	    //$( "#vessels" ).append( '\n' );
	}

	$( "html, body" ).stop();
	$( "html, body" ).animate( { scrollTop: $( "body" ).height() }, 1 );

    //

	addedlinks = 0;
	for( var id in world.rawlocations[currentWorldLocationID].linkadditions )
	{
	    var link = world.rawlocations[currentWorldLocationID].linkadditions[id];

	    var linklocationid = findlocation( link.target );
	    if ( linklocationid != -1 )
	    {
	        var finallinktitle = link.title === '' ? world.rawlocations[linklocationid].name : link.title;

	        addvessel( linklocationid, finallinktitle, true, link.token, link.action, link );
	        console.log( "inquisitor: Adding link to: " + linklocationid );
	    }
	    else
	    {
	        console.log( "inquisitor: Bad link" );
	    }
	}

	if ( addedlinks > 0 )
	{
	    $( "#vessels" ).append( '\n' );
	}

    //

	if ( location.isobject || currentWorldLocationID === 0 )
	{
	    var parentid = world.rawlocations[currentWorldLocationID].parent.id;
	    var leavemessage = "Leave";
	    var leaveid = parentid;
	    if ( !isfirstchild && !world.rawlocations[firstchild].isobject && leaveid == -1 )
	    {
	        leaveid = firstchild;
	        console.log( "inquisitor: Leaving to first sibling: " + leaveid );
	    }
	    else if ( leaveid === -1 || ( leaveid == undefined && leaveid == null ) )
	    {
	        leaveid = world.rawlocations[currentWorldLocationID].parent.parent.id;
	        console.log( "inquisitor: Leaving to first child of parent: " + leaveid );
	        console.log( world.rawlocations[currentWorldLocationID].parent );
	    }
	    else
	    {
	        console.log( "inquisitor: Leaving to parent: " + leaveid );
	        console.log( world.rawlocations[currentWorldLocationID].parent );
	    }

	    if ( currentWorldLocationID === 0 )
	    {
	        leaveid = 1;
	        leavemessage = "Enter";
	    }

	    console.log( "inquisitor: Leave goes to: " + leaveid );

	    if ( leaveid > -1 )
	    {
	        addvessel( leaveid, leavemessage, true );
	    }

	    /*else
	    {
	        child = 0;
	        for ( var objectname in world.regions )
	        {
	            var childid = world.regions[objectname].id;
	            if ( childid != 0 && childid != -1 && childid != currentWorldLocationID )
	            {
	                console.log( "inquisitor: Enumerating region: " + childid );
	                addvessel( childid, world.rawlocations[childid].region );
	            }
	            child++;
	        }
	    }*/
	}

    //
}

//$( 'body' ).addClass( 'fade' );
function clear()
{
    var center = ( $( "#core" ).height() - $( "#div4" ).height() ) / 2;
    console.log( "inquisitor: Center: " + center );
    //$( "#div4" ).css( { "top": center } );

    $( "#superlocation" ).html( "" );
	$("#location").html("");
	$( "#note" ).html( "" );
	$( "#event" ).html( "" );
	$( "#seperator" ).html( "" );
	$( "#vessels" ).html( "" );
	$( "#objects" ).html( "" );
	$( "#region" ).html( "" );
	$( "#subregion" ).html( "" );
	addedlinks = 0;

	$( "#dialogue" ).hide();
	$( "#dialoguefader1" ).hide();
	$( "#dialoguefader2" ).hide();
	$( "#dialoguedivider1" ).hide();
	$( "#dialoguedivider2" ).hide();

	//$( "#history" ).html( "" );
}